import { createAsyncThunk, createSlice } from "@reduxjs/toolkit";

import { BASE_API_URL_STG } from "@env";
import { mutationResponse } from "../util/processResponse.js";

const REGISTER_URL = `${BASE_API_URL_STG}/user/registration`;

const initialState = {
    reCaptchaToken: false,
    captchaToken: "",
    data: {},
    loading: false,
};

export const registrationUsingEmailAndPassword = createAsyncThunk(
    "auth/registration",
    async (params) => {
        const { data } = params;
        try {
            const response = await mutationResponse(REGISTER_URL, "POST", data);
            return response;
        } catch (err) {}
    }
);

const registrationUsingEmailAndPasswordSlice = createSlice({
    name: "registration",
    initialState,
    reducers: {
        storeRecaptchaToken: (state, { payload }) => {
            state.reCaptchaToken = payload;
        },
        storeCaptchaToken: (state, { payload }) => {
            state.captchaToken = payload;
        },
    },
    extraReducers: (builder) => {
        builder.addCase(registrationUsingEmailAndPassword.pending, (state) => {
            state.loading = true;
        });
        builder.addCase(
            registrationUsingEmailAndPassword.fulfilled,
            (state, { payload = {} }) => {
                state.loading = false;
                state.data = payload;
            }
        );
        builder.addCase(registrationUsingEmailAndPassword.rejected, (state) => {
            state.loading = false;
            state.data = {};
        });
    },
});

export default registrationUsingEmailAndPasswordSlice.reducer;
export const { storeRecaptchaToken, storeCaptchaToken } =
    registrationUsingEmailAndPasswordSlice.actions;
